/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.base;

import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWException;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.base.VWDebug;
import filenet.vw.base.VWWSRRRegistry;
import filenet.vw.base.VWXMLWrapper;
import filenet.vw.base.XMLHelper;
import filenet.vw.base.logging.Level;
import filenet.vw.base.logging.Logger;
import filenet.ws.utils.WSConstants;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VWWSRRRegistryList {
    public static final String XML_TAG_WSDL = "WSDL";
    public static final String XML_TAG_WSRR_REGISTRY_LIST = "WSRRRegistryList";
    public static final String WSRR_TAG = "WSRRRegistryList";
    public static final String XML_ATTRIBUTE_VERSION = "Version";
    public static final String XML_VERSION_1_0 = "1.0";
    public static final String VW_WSRR_NAME_SPACE = "http://filenet.com/vw/base/WSRRRegistryList/1.0";
    public static final String ATTRINFO_CONFIG_WSRR_REGISTRIES = "F_WSRRRegistries";
    protected Element base = null;
    private VWAttributeInfo m_vwAttributeInfo = null;
    private VWSession m_vwSession = null;
    private Vector m_WSRRRegistryVector = new Vector();
    private String m_key = "F_WSRRRegistries";
    private VWXMLWrapper m_xmlWrapper = null;
    private static Logger m_logger = Logger.getLogger("filenet.vw.base");
    private static final String m_className = "VWWSRRRegistryList";

    public static String _get_FILE_DATE() {
        return "$Date:   16 Aug 2007 15:03:10  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   lnguyen  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.5  $";
    }

    public VWWSRRRegistryList(VWSession session) {
        try {
            this.m_vwSession = session;
            if (this.m_vwSession != null) {
                VWSystemConfiguration sysConfig = this.m_vwSession.fetchSystemConfiguration();
                this.m_vwAttributeInfo = sysConfig.getAttributeInfo();
                this.fetchWSRRRegistryList();
            }
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
        }
    }

    public VWWSRRRegistryList(VWSession session, VWAttributeInfo vwAttributeInfo) {
        try {
            this.m_vwAttributeInfo = vwAttributeInfo;
            this.m_vwSession = session;
            this.fetchWSRRRegistryList();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public VWWSRRRegistryList(VWAttributeInfo vwAttributeInfo, String sWSRRxml, VWSession session) throws Exception {
        this.m_vwAttributeInfo = vwAttributeInfo;
        this.m_vwSession = session;
        this.parseXML(sWSRRxml);
    }

    public static VWWSRRRegistry getWSRRRegistry(VWSession session, String WSRRName, int portNum) {
        try {
            if (session != null) {
                VWWSRRRegistryList regList = new VWWSRRRegistryList(session);
                return regList.getWSRRRegistry(WSRRName, portNum);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public VWWSRRRegistry getWSRRRegistry(String WSRRName) {
        VWWSRRRegistry vwWSRRRegistry = null;
        if (WSRRName != null && WSRRName.length() > 0 && this.m_WSRRRegistryVector != null && this.m_WSRRRegistryVector.size() > 0) {
            boolean bFind = false;
            for (int i = 0; i < this.m_WSRRRegistryVector.size(); ++i) {
                vwWSRRRegistry = (VWWSRRRegistry)this.m_WSRRRegistryVector.elementAt(i);
                if (WSRRName.compareTo(vwWSRRRegistry.getServerName()) != 0) continue;
                bFind = true;
                break;
            }
            if (!bFind) {
                vwWSRRRegistry = null;
            }
        }
        return vwWSRRRegistry;
    }

    public VWWSRRRegistry getWSRRRegistry(String WSRRName, int portNum) {
        VWWSRRRegistry vwWSRRRegistry = null;
        try {
            if (WSRRName != null && WSRRName.length() > 0 && this.m_WSRRRegistryVector != null && this.m_WSRRRegistryVector.size() > 0) {
                boolean bFind = false;
                int iPort = -1;
                for (int i = 0; i < this.m_WSRRRegistryVector.size(); ++i) {
                    vwWSRRRegistry = (VWWSRRRegistry)this.m_WSRRRegistryVector.elementAt(i);
                    String port = vwWSRRRegistry.getPort();
                    iPort = port == null || port != null && port.compareTo("") == 0 ? -1 : new Integer(port);
                    if (WSRRName.compareTo(vwWSRRRegistry.getServerName()) != 0 || iPort != portNum) continue;
                    bFind = true;
                    break;
                }
                if (!bFind) {
                    vwWSRRRegistry = null;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
        return vwWSRRRegistry;
    }

    public VWSession getSession() {
        return this.m_vwSession;
    }

    public Vector getWSRRRegistryVector() {
        return this.m_WSRRRegistryVector;
    }

    public VWWSRRRegistry[] getWSRRRegistries() {
        Object[] arrayList = null;
        if (this.m_WSRRRegistryVector != null && this.m_WSRRRegistryVector.size() > 0) {
            arrayList = new VWWSRRRegistry[this.m_WSRRRegistryVector.size()];
            this.m_WSRRRegistryVector.copyInto(arrayList);
        }
        return arrayList;
    }

    public VWWSRRRegistry[] getPublishableWSRRRegistries() {
        int sz;
        Object[] arrayList = null;
        if (this.m_WSRRRegistryVector != null && (sz = this.m_WSRRRegistryVector.size()) > 0) {
            Vector<VWWSRRRegistry> tmpVector = new Vector<VWWSRRRegistry>();
            for (int i = 0; i < sz; ++i) {
                VWWSRRRegistry WSRRReg = (VWWSRRRegistry)this.m_WSRRRegistryVector.elementAt(i);
                if (!WSRRReg.getPublish()) continue;
                tmpVector.add(WSRRReg);
            }
            int len = tmpVector.size();
            if (len > 0) {
                arrayList = new VWWSRRRegistry[len];
                tmpVector.copyInto(arrayList);
            }
        }
        return arrayList;
    }

    public void setWSRRRegistryVector(Vector WSRRRegistryList) {
        this.m_WSRRRegistryVector = WSRRRegistryList;
    }

    public void setWSRRRegistries(VWWSRRRegistry[] WSRRRegistryArray) {
        if (this.m_WSRRRegistryVector == null) {
            this.m_WSRRRegistryVector = new Vector();
        } else {
            this.m_WSRRRegistryVector.clear();
        }
        if (WSRRRegistryArray == null) {
            return;
        }
        int sz = WSRRRegistryArray.length;
        if (sz <= 0) {
            return;
        }
        for (int i = 0; i < sz; ++i) {
            this.m_WSRRRegistryVector.add(WSRRRegistryArray[i]);
        }
    }

    public void updateAttribute() {
        try {
            String sWSRRxml = this.toXML();
            this.m_vwAttributeInfo.setFieldValue(this.m_key, sWSRRxml);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void save(VWSession session) {
        try {
            this.updateAttribute();
            VWSystemConfiguration sysConfig = session.fetchSystemConfiguration();
            sysConfig.setAttributeInfo(this.m_vwAttributeInfo);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public String toXML() {
        return this.toXML_v1();
    }

    public String toXML_v1() {
        String xmlString = null;
        try {
            Document doc = this.saveToDOM();
            if (this.m_xmlWrapper == null) {
                this.m_xmlWrapper = new VWXMLWrapper("WSRRRegistryList", VW_WSRR_NAME_SPACE);
            }
            xmlString = this.m_xmlWrapper.toXML(doc);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return xmlString;
    }

    public void releaseResources() {
        this.m_vwAttributeInfo = null;
        if (this.m_WSRRRegistryVector != null) {
            int sz = this.m_WSRRRegistryVector.size();
            for (int i = 0; i < sz; ++i) {
                ((VWWSRRRegistry)this.m_WSRRRegistryVector.elementAt(i)).releaseResources();
            }
            this.m_WSRRRegistryVector.clear();
            this.m_WSRRRegistryVector = null;
        }
        this.m_key = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void parseXML(String sWSRRxml) throws VWException {
        try {
            if (this.m_WSRRRegistryVector == null) {
                this.m_WSRRRegistryVector = new Vector();
            }
            if (sWSRRxml == null || sWSRRxml.length() <= 0) return;
            this.m_xmlWrapper = new VWXMLWrapper(sWSRRxml);
            Node registryList = this.m_xmlWrapper.getRootNode();
            NamedNodeMap attributes = registryList.getAttributes();
            Node versionAttrNode = attributes.getNamedItem(XML_ATTRIBUTE_VERSION);
            if (versionAttrNode != null) {
                String sVersion = versionAttrNode.getNodeValue();
                if (sVersion != null) {
                    if (sVersion.compareTo(XML_VERSION_1_0) != 0) throw new VWException("filenet.vw.base.VWWSRRRegistryList.ParseXMLBadVersion", "version {0} is not supported.", sVersion);
                    this.parseXML_v1_0(registryList);
                    return;
                } else {
                    this.parseXML_v0(registryList);
                }
                return;
            } else {
                this.parseXML_v0(registryList);
            }
            return;
        }
        catch (Exception ex) {
            throw new VWException("filenet.vw.base.VWWSRRRegistryList.parseXML", "Failed to parse WSRR registry XML. {0}", ex.getMessage());
        }
    }

    protected void parseXML_v1_0(Node registryList) throws VWException {
        String m_method = "parseXML_v1_0:";
        try {
            if (registryList != null) {
                NamedNodeMap attributes = registryList.getAttributes();
                NodeList nodeList = registryList.getChildNodes();
                String nodeName = null;
                Node node = null;
                if (nodeList != null) {
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Element wsrrRegistryEle;
                        node = nodeList.item(i);
                        if (node == null || !(node instanceof Element) || (nodeName = (wsrrRegistryEle = (Element)node).getNodeName()).compareTo("WSRRRegistry") != 0) continue;
                        VWWSRRRegistry theWSRRRegistry = new VWWSRRRegistry((Element)node);
                        this.m_WSRRRegistryVector.add(theWSRRRegistry);
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new VWException("filenet.vw.base.VWWSRRRegistryList.parseXML_v1_0", "Failed to parse WSRR registry XML. {0}", ex.getMessage());
        }
    }

    protected void parseXML_v0(Node registryList) throws VWException {
        String m_method = "parseXML_v0:";
        try {
            if (registryList != null) {
                NamedNodeMap attributes = registryList.getAttributes();
                NodeList nodeList = registryList.getChildNodes();
                String nodeName = null;
                Node node = null;
                if (nodeList != null) {
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        node = nodeList.item(i);
                        if (node == null || !(node instanceof Element)) continue;
                        Element WSRRRegistryEle = (Element)node;
                        nodeName = WSRRRegistryEle.getNodeName();
                        String sPublish = WSRRRegistryEle.getAttribute("publish");
                        String sServerName = WSRRRegistryEle.getAttribute("servername");
                        String sPort = WSRRRegistryEle.getAttribute("port");
                        String sUserInfo = WSRRRegistryEle.getAttribute("userinfo");
                        boolean bPublish = false;
                        if (sPublish.equals("1")) {
                            bPublish = true;
                        }
                        VWWSRRRegistry theWSRRRegistry = new VWWSRRRegistry(WSConstants.UTF8Decode(sServerName), WSConstants.UTF8Decode(sPort), WSConstants.UTF8Decode(sUserInfo), bPublish);
                        this.m_WSRRRegistryVector.add(theWSRRRegistry);
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new VWException("filenet.vw.base.VWWSRRRegistryList.parseXML_v0", "Failed to parse WSRR registry XML. {0}", ex.getMessage());
        }
    }

    protected void parseXML_v0(String sWSRRxml) throws VWException {
        String m_method = "parseXML_v0:";
        try {
            if (this.m_WSRRRegistryVector == null) {
                this.m_WSRRRegistryVector = new Vector();
            }
            if (sWSRRxml != null && sWSRRxml.length() > 0) {
                this.m_xmlWrapper = new VWXMLWrapper(sWSRRxml);
                Node registryList = this.m_xmlWrapper.getRootNode();
                NamedNodeMap attributes = registryList.getAttributes();
                NodeList nodeList = registryList.getChildNodes();
                String nodeName = null;
                Node node = null;
                if (nodeList != null) {
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        node = nodeList.item(i);
                        if (node == null || !(node instanceof Element)) continue;
                        Element WSRRRegistryEle = (Element)node;
                        nodeName = WSRRRegistryEle.getNodeName();
                        String sPublish = WSRRRegistryEle.getAttribute("publish");
                        String sServerName = WSRRRegistryEle.getAttribute("servername");
                        String sPort = WSRRRegistryEle.getAttribute("port");
                        String sUserInfo = WSRRRegistryEle.getAttribute("userinfo");
                        boolean bPublish = false;
                        if (sPublish.equals("1")) {
                            bPublish = true;
                        }
                        VWWSRRRegistry theWSRRRegistry = new VWWSRRRegistry(WSConstants.UTF8Decode(sServerName), WSConstants.UTF8Decode(sPort), WSConstants.UTF8Decode(sUserInfo), bPublish);
                        this.m_WSRRRegistryVector.add(theWSRRRegistry);
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new VWException("filenet.vw.base.VWWSRRRegistryList.parseXML_v0", "Failed to parse WSRR registry XML. {0}", ex.getMessage());
        }
    }

    public Document saveToDOM() {
        Document document = null;
        try {
            document = XMLHelper.newDocumentViaDOM();
            Element rootNode = document.createElement("WSRRRegistryList");
            document.appendChild(rootNode);
            rootNode = document.getDocumentElement();
            rootNode.setAttribute("xmlns", VW_WSRR_NAME_SPACE);
            rootNode.appendChild(document.createTextNode("\n"));
            rootNode.setAttribute(XML_ATTRIBUTE_VERSION, XML_VERSION_1_0);
            if (this.m_WSRRRegistryVector != null) {
                int sz = this.m_WSRRRegistryVector.size();
                for (int i = 0; i < sz; ++i) {
                    ((VWWSRRRegistry)this.m_WSRRRegistryVector.elementAt(i)).saveToXML(rootNode);
                }
            }
        }
        catch (Exception ex) {
            m_logger.log(Level.FINE, "VWWSRRRegistryList::saveToXML.", ex);
            VWDebug.logException(ex);
        }
        return document;
    }

    public void mergeRegistryList(VWWSRRRegistryList sourceList) throws VWException {
        try {
            if (sourceList == null) {
                return;
            }
            Vector sourceRegistryVector = sourceList.getWSRRRegistryVector();
            if (sourceRegistryVector == null || sourceRegistryVector.size() <= 0) {
                return;
            }
            int sourceListLen = sourceRegistryVector.size();
            int currentListLen = 0;
            if (this.m_WSRRRegistryVector != null) {
                currentListLen = this.m_WSRRRegistryVector.size();
            }
            if (currentListLen == 0) {
                this.m_WSRRRegistryVector = sourceRegistryVector;
                return;
            }
            String sourceName = null;
            String destName = null;
            for (int i = 0; i < sourceListLen; ++i) {
                VWWSRRRegistry sourceWSRRRegistry = (VWWSRRRegistry)sourceRegistryVector.elementAt(i);
                if (sourceWSRRRegistry == null || (sourceName = sourceWSRRRegistry.getServerName()) == null || sourceName.length() <= 0) continue;
                if (currentListLen == 0) {
                    this.m_WSRRRegistryVector.add(sourceRegistryVector.elementAt(i));
                    continue;
                }
                boolean bFound = false;
                for (int j = 0; j < currentListLen; ++j) {
                    VWWSRRRegistry destWSRRRegistry = (VWWSRRRegistry)this.m_WSRRRegistryVector.elementAt(j);
                    if (destWSRRRegistry == null || (destName = destWSRRRegistry.getServerName()) == null || destName.length() <= 0 || sourceName.compareTo(destName) != 0) continue;
                    bFound = true;
                    break;
                }
                if (bFound) continue;
                this.m_WSRRRegistryVector.add(sourceRegistryVector.elementAt(i));
            }
            return;
        }
        catch (Exception ex) {
            throw new VWException("filenet.vw.base.VWWSRRRegistryList.MergeWSRRRegistries", "Failed to merge WSRR registry. {0}", ex.getMessage());
        }
    }

    private void fetchWSRRRegistryList() {
        String m_method = "fetchWSRRRegistryList:";
        try {
            String sWSRRxml = (String)this.m_vwAttributeInfo.getFieldValue(this.m_key);
            if (m_logger.isLoggable(Level.FINEST)) {
                m_logger.finest(m_className, m_method, sWSRRxml);
            }
            this.clearWSRRRegistryVector();
            this.parseXML(sWSRRxml);
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
        }
    }

    private void clearWSRRRegistryVector() {
        int sz = this.m_WSRRRegistryVector.size();
        for (int i = 0; i < sz; ++i) {
            ((VWWSRRRegistry)this.m_WSRRRegistryVector.elementAt(i)).releaseResources();
        }
        this.m_WSRRRegistryVector.clear();
    }

    private void dumpXml(String strXML, String filePath) {
        try {
            FileOutputStream outStream = new FileOutputStream(filePath);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)outStream, "UTF8");
            out.write(strXML);
            ((Writer)out).flush();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

